﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;
using Gemini.Core.BL.Interface;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodCompetencesIndex : BaseAPIMethod
        {

            public MethodCompetencesIndex(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "competencesindex"; }
            }

            protected override bool DoValidate()
            {
                return true;
            }

            protected override void DoReadRequestParams()
            {
                // tutaj nic nie czytamy z sesji
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (User != null)
                {
                    StatusCode = StatusCodeType.OK;
                    long _suggested_context_id = 0;
                    long _suggested_course_id = 0;
                    List<GCompetencesIndex> _listGCompetencesIndex = Component.BLELearning.APIMobile.GetGCompetencesIndexList(User, out _suggested_context_id, out _suggested_course_id);
                    return new GResponseData_CompetencesIndex() { Competences = _listGCompetencesIndex, count = _listGCompetencesIndex.Count, suggested_context_id = _suggested_context_id, suggested_course_id = _suggested_course_id };
                }
                return null;
            }
        }
    }
}